#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;

//using gov.va.med.vbecs;
using gov.va.med.vbecs.GUI.controls;

using BOL = gov.va.med.vbecs.BOL;
using Common = gov.va.med.vbecs.Common;

#endregion

namespace gov.va.med.vbecs.GUI
{	
 	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Luke Meyer</Developer>
	/// <Developer>CameronTaylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/5/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>

		#endregion

	public class FrmShipmentIn : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmShipmentIn));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpNewInvoice = new System.Windows.Forms.GroupBox();
			this.btnSelectInvoice = new System.Windows.Forms.Button();
			this.cmbProcessedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblProcessedBy = new System.Windows.Forms.Label();
			this.txtInvoice = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.cmbSource = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dtpProcessingDT = new System.Windows.Forms.DateTimePicker();
			this.lblProcessingDT = new System.Windows.Forms.Label();
			this.lblSource = new System.Windows.Forms.Label();
			this.lblInvoice = new System.Windows.Forms.Label();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpType = new System.Windows.Forms.GroupBox();
			this.txtScan = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.pictureBox6 = new System.Windows.Forms.PictureBox();
			this.rdoUnknown = new System.Windows.Forms.RadioButton();
			this.rdoCodabar = new System.Windows.Forms.RadioButton();
			this.rdoISBT = new System.Windows.Forms.RadioButton();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.ttShipment = new System.Windows.Forms.ToolTip(this.components);
			this.formErrorProvider = new gov.va.med.vbecs.GUI.controls.VbecsErrorProvider();
			this.grpNewInvoice.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpType.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(442, 30);
			this.vbecsLogo1.TabIndex = 4;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 267);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(360, 256);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.ttShipment.SetToolTip(this.btnCancel, "Click to disregard changes and return");
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpNewInvoice
			// 
			this.grpNewInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpNewInvoice.BackColor = System.Drawing.SystemColors.Control;
			this.grpNewInvoice.Controls.Add(this.btnSelectInvoice);
			this.grpNewInvoice.Controls.Add(this.cmbProcessedBy);
			this.grpNewInvoice.Controls.Add(this.lblProcessedBy);
			this.grpNewInvoice.Controls.Add(this.txtInvoice);
			this.grpNewInvoice.Controls.Add(this.pictureBox2);
			this.grpNewInvoice.Controls.Add(this.cmbSource);
			this.grpNewInvoice.Controls.Add(this.dtpProcessingDT);
			this.grpNewInvoice.Controls.Add(this.lblProcessingDT);
			this.grpNewInvoice.Controls.Add(this.lblSource);
			this.grpNewInvoice.Controls.Add(this.lblInvoice);
			this.grpNewInvoice.Location = new System.Drawing.Point(64, 36);
			this.grpNewInvoice.Name = "grpNewInvoice";
			this.grpNewInvoice.Size = new System.Drawing.Size(372, 120);
			this.grpNewInvoice.TabIndex = 0;
			this.grpNewInvoice.TabStop = false;
			// 
			// btnSelectInvoice
			// 
			this.btnSelectInvoice.AccessibleDescription = "find";
			this.btnSelectInvoice.AccessibleName = "find";
			this.btnSelectInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectInvoice.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectInvoice.Location = new System.Drawing.Point(332, 16);
			this.btnSelectInvoice.Name = "btnSelectInvoice";
			this.btnSelectInvoice.Size = new System.Drawing.Size(24, 20);
			this.btnSelectInvoice.TabIndex = 2;
			this.btnSelectInvoice.Text = "find";
			this.btnSelectInvoice.Click += new System.EventHandler(this.btnSelectInvoice_Click);
			// 
			// cmbProcessedBy
			// 
			this.cmbProcessedBy.AccessibleDescription = "Processed By";
			this.cmbProcessedBy.AccessibleName = "Processed By";
			this.cmbProcessedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbProcessedBy.Interval = 500;
			this.cmbProcessedBy.Location = new System.Drawing.Point(156, 88);
			this.cmbProcessedBy.Name = "cmbProcessedBy";
			this.cmbProcessedBy.Size = new System.Drawing.Size(200, 22);
			this.cmbProcessedBy.TabIndex = 8;
			this.ttShipment.SetToolTip(this.cmbProcessedBy, "Choose a local supplier");
			this.cmbProcessedBy.Leave += new System.EventHandler(this.cmbProcessedBy_Leave);
			// 
			// lblProcessedBy
			// 
			this.lblProcessedBy.Location = new System.Drawing.Point(32, 88);
			this.lblProcessedBy.Name = "lblProcessedBy";
			this.lblProcessedBy.Size = new System.Drawing.Size(120, 20);
			this.lblProcessedBy.TabIndex = 7;
			this.lblProcessedBy.Text = "Processed By*";
			this.lblProcessedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtInvoice
			// 
			this.txtInvoice.AccessibleDescription = "Invoice Number";
			this.txtInvoice.AccessibleName = "Invoice Number";
			this.txtInvoice.Barcode = false;
			this.txtInvoice.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtInvoice.Location = new System.Drawing.Point(156, 16);
			this.txtInvoice.MaxLength = 14;
			this.txtInvoice.Name = "txtInvoice";
			this.txtInvoice.Size = new System.Drawing.Size(176, 20);
			this.txtInvoice.TabIndex = 1;
			this.txtInvoice.Text = "";
			this.ttShipment.SetToolTip(this.txtInvoice, "Enter an invoice number");
			this.txtInvoice.TextChanged += new System.EventHandler(this.txtInvoice_TextChanged);
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(12, 16);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(20, 20);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 34;
			this.pictureBox2.TabStop = false;
			// 
			// cmbSource
			// 
			this.cmbSource.AccessibleDescription = "Source Shipper";
			this.cmbSource.AccessibleName = "Source Shipper";
			this.cmbSource.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbSource.Interval = 500;
			this.cmbSource.Location = new System.Drawing.Point(156, 40);
			this.cmbSource.Name = "cmbSource";
			this.cmbSource.Size = new System.Drawing.Size(200, 22);
			this.cmbSource.TabIndex = 4;
			this.ttShipment.SetToolTip(this.cmbSource, "Choose a local supplier");
			this.cmbSource.TextChanged += new System.EventHandler(this.cmbSource_TextChanged);
			this.cmbSource.SelectedIndexChanged += new System.EventHandler(this.cmbSource_SelectedIndexChanged);
			// 
			// dtpProcessingDT
			// 
			this.dtpProcessingDT.AccessibleDescription = "Date Received";
			this.dtpProcessingDT.AccessibleName = "Date Received";
			this.dtpProcessingDT.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpProcessingDT.CustomFormat = "";
			this.dtpProcessingDT.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpProcessingDT.Location = new System.Drawing.Point(156, 64);
			this.dtpProcessingDT.Name = "dtpProcessingDT";
			this.dtpProcessingDT.TabIndex = 6;
			this.ttShipment.SetToolTip(this.dtpProcessingDT, "Choose a processing date/time");
			this.dtpProcessingDT.CloseUp += new System.EventHandler(this.dtpProcessingDT_Leave);
			this.dtpProcessingDT.Leave += new System.EventHandler(this.dtpProcessingDT_Leave);
			// 
			// lblProcessingDT
			// 
			this.lblProcessingDT.Location = new System.Drawing.Point(32, 64);
			this.lblProcessingDT.Name = "lblProcessingDT";
			this.lblProcessingDT.Size = new System.Drawing.Size(120, 20);
			this.lblProcessingDT.TabIndex = 5;
			this.lblProcessingDT.Text = "Date Received*";
			this.lblProcessingDT.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSource
			// 
			this.lblSource.Location = new System.Drawing.Point(32, 40);
			this.lblSource.Name = "lblSource";
			this.lblSource.Size = new System.Drawing.Size(120, 20);
			this.lblSource.TabIndex = 3;
			this.lblSource.Text = "Source (Shipper)*";
			this.lblSource.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblInvoice
			// 
			this.lblInvoice.Location = new System.Drawing.Point(32, 16);
			this.lblInvoice.Name = "lblInvoice";
			this.lblInvoice.Size = new System.Drawing.Size(120, 20);
			this.lblInvoice.TabIndex = 0;
			this.lblInvoice.Text = "Invoice Number*";
			this.lblInvoice.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(56, 212);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 36;
			this.pictureBox1.TabStop = false;
			// 
			// grpType
			// 
			this.grpType.AccessibleDescription = "Labeling Type";
			this.grpType.AccessibleName = "Labeling Type";
			this.grpType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpType.Controls.Add(this.txtScan);
			this.grpType.Controls.Add(this.pictureBox6);
			this.grpType.Controls.Add(this.rdoUnknown);
			this.grpType.Controls.Add(this.rdoCodabar);
			this.grpType.Controls.Add(this.rdoISBT);
			this.grpType.Location = new System.Drawing.Point(64, 160);
			this.grpType.Name = "grpType";
			this.grpType.Size = new System.Drawing.Size(372, 88);
			this.grpType.TabIndex = 1;
			this.grpType.TabStop = false;
			this.grpType.Text = "Labeling Type*";
			this.ttShipment.SetToolTip(this.grpType, "Choose a labeling type");
			// 
			// txtScan
			// 
			this.txtScan.AccessibleDescription = "Unknown: Scan to determine";
			this.txtScan.AccessibleName = "Unknown: Scan to determine";
			this.txtScan.Barcode = false;
			this.txtScan.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtScan.Location = new System.Drawing.Point(192, 56);
			this.txtScan.Name = "txtScan";
			this.txtScan.Size = new System.Drawing.Size(160, 20);
			this.txtScan.TabIndex = 3;
			this.txtScan.Text = "";
			this.txtScan.TextChanged += new System.EventHandler(this.txtScan_TextChanged);
			// 
			// pictureBox6
			// 
			this.pictureBox6.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox6.Image")));
			this.pictureBox6.Location = new System.Drawing.Point(168, 60);
			this.pictureBox6.Name = "pictureBox6";
			this.pictureBox6.Size = new System.Drawing.Size(20, 20);
			this.pictureBox6.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox6.TabIndex = 28;
			this.pictureBox6.TabStop = false;
			this.pictureBox6.Visible = false;
			// 
			// rdoUnknown
			// 
			this.rdoUnknown.AccessibleDescription = "Unknown: Scan to determine";
			this.rdoUnknown.AccessibleName = "Unknown: Scan to determine";
			this.rdoUnknown.Location = new System.Drawing.Point(8, 56);
			this.rdoUnknown.Name = "rdoUnknown";
			this.rdoUnknown.Size = new System.Drawing.Size(176, 24);
			this.rdoUnknown.TabIndex = 2;
			this.rdoUnknown.Text = "&Unknown: Scan to determine";
			this.ttShipment.SetToolTip(this.rdoUnknown, "Select if labeling type of shipment is unknown, then scan a barcode, the system w" +
				"ill determine the type");
			this.rdoUnknown.CheckedChanged += new System.EventHandler(this.rdoUnknown_CheckedChanged);
			// 
			// rdoCodabar
			// 
			this.rdoCodabar.AccessibleDescription = "Codabar";
			this.rdoCodabar.AccessibleName = "Codabar";
			this.rdoCodabar.Location = new System.Drawing.Point(8, 20);
			this.rdoCodabar.Name = "rdoCodabar";
			this.rdoCodabar.Size = new System.Drawing.Size(96, 16);
			this.rdoCodabar.TabIndex = 0;
			this.rdoCodabar.TabStop = true;
			this.rdoCodabar.Text = "Co&dabar";
			this.ttShipment.SetToolTip(this.rdoCodabar, "Select the labeling type of the shipment");
			this.rdoCodabar.CheckedChanged += new System.EventHandler(this.rdoCodabar_CheckedChanged);
			// 
			// rdoISBT
			// 
			this.rdoISBT.AccessibleDescription = "I S B T 128";
			this.rdoISBT.AccessibleName = "I S B T 128";
			this.rdoISBT.Location = new System.Drawing.Point(8, 40);
			this.rdoISBT.Name = "rdoISBT";
			this.rdoISBT.Size = new System.Drawing.Size(96, 16);
			this.rdoISBT.TabIndex = 1;
			this.rdoISBT.Text = "&ISBT 128";
			this.ttShipment.SetToolTip(this.rdoISBT, "Select the labeling type of the shipment");
			this.rdoISBT.CheckedChanged += new System.EventHandler(this.rdoISBT_CheckedChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(280, 256);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// formErrorProvider
			// 
			this.formErrorProvider.ContainerControl = this;
			// 
			// FrmShipmentIn
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(442, 283);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpType);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpNewInvoice);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Incoming_Shipment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(450, 310);
			this.Name = "FrmShipmentIn";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Process Incoming Shipment - Define Invoice";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmShipmentIn_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpNewInvoice, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpType, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpNewInvoice.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpType.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Variables

		/// <summary>
		/// Shipment object.  Collects information used in processing an incoming shipment.
		/// </summary>
		private BOL.IncomingShipment _Shipment;
		private System.Collections.ArrayList _alCollectionFacility;
		private System.Collections.ArrayList _alVbecsUsers;
		
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpNewInvoice;
		private System.Windows.Forms.DateTimePicker dtpProcessingDT;
		private System.Windows.Forms.Label lblProcessingDT;
		private System.Windows.Forms.Label lblSource;
		private System.Windows.Forms.Label lblInvoice;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.GroupBox grpType;
		private System.Windows.Forms.PictureBox pictureBox6;
		private System.Windows.Forms.RadioButton rdoCodabar;
		private System.Windows.Forms.RadioButton rdoISBT;
		private System.Windows.Forms.RadioButton rdoUnknown;
		private System.ComponentModel.IContainer components = null;
		private ToolTip ttShipment; // **** 508 Compliance ***
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSource;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.VbecsErrorProvider formErrorProvider; // **** 508 Compliance ***
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbProcessedBy;
		private System.Windows.Forms.Label lblProcessedBy;
		private System.Windows.Forms.Button btnSelectInvoice;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtScan;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtInvoice;
		private string _processedByError = string.Empty;

		
		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/30/2002</CreationDate>
		/// <summary>Controls the creation of the form</summary>
		public FrmShipmentIn()
		{
			InitializeComponent();
			SetComponentProperties();

			LoadCollectionFacilities();
			LoadVbecsUsers();

			vbecsLogo1.Title="Define Invoice";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC001.DlgSelectIncomingShipment());

			_Shipment = new BOL.IncomingShipment(System.Guid.NewGuid());
			ResetFormControlsAndBusinessObjects();			
			ReattachValidStateChangeEventHandlers();
			this._Shipment.ShipmentDate = dtpProcessingDT.Value;
			this.cmbSource.Enabled = false;
			this.dtpProcessingDT.Enabled = false;
			this.cmbProcessedBy.Enabled = false;
			this.IsDirty = false;
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2002</CreationDate>
		/// <summary>
		/// If shipment is codabar or ISBT 128
		/// </summary>
		public bool Codabar
		{
			get { return rdoCodabar.Checked; }
		}

		#endregion

		#region Methods

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Loads collection facilities dropdown
		/// </summary>
		private void LoadCollectionFacilities()
		{
			cmbSource.Items.Clear();			
			_alCollectionFacility = BOL.ProductShipper.GetProductShippersByDivisionLookUpAL();
			cmbSource.Items.Add(new Common.DataItem("",""));
			
			foreach(Object obj in this._alCollectionFacility)
			{
				BOL.ProductShipper ProductShipper = (BOL.ProductShipper) obj;
				cmbSource.Items.Add(new Common.DataItem(ProductShipper.ProductShipperGuid.ToString(), ProductShipper.FacilityName));
			}
		}

		private void LoadVbecsUsers()
		{
			this.cmbProcessedBy.Items.Clear();
			this._alVbecsUsers = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );
			//they cannot de-select this so no blank row needed
			foreach(Object obj in this._alVbecsUsers)
			{
				BOL.VbecsUser vbecsUser = (BOL.VbecsUser) obj;
				cmbProcessedBy.Items.Add(vbecsUser.UserName);
			}
			cmbProcessedBy.Text = ThisUser.UserName;
		}

		private void ResetFormControlsAndBusinessObjects()
		{
			ReattachValidStateChangeEventHandlers();
			this._Shipment = new BOL.IncomingShipment(System.Guid.Empty);
			_Shipment.SetInitialBrokenRules( this.Name, "Shipment" );
			_Shipment.LocalSupplier.SetInitialBrokenRules( this.Name, "LocalSupplier" );
			_Shipment.ShipmentDirection = Common.ShipmentDirection.IncomingShipment;
			_Shipment.ShipmentGuid = Guid.Empty;
			_Shipment.LocalSupplierGuid = Guid.Empty;

			_Shipment.LocalSupplier.LocalSupplierGuid = Guid.Empty;
			this.dtpProcessingDT.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.cmbProcessedBy.Text = ThisUser.UserName;
			this._Shipment.ShipmentDate = dtpProcessingDT.Value;
			this.rdoUnknown.Checked = true;
			this.txtInvoice.Enabled = true;
			this.cmbSource.Enabled = true;
			this.dtpProcessingDT.Enabled = true;
			this.cmbProcessedBy.Enabled = true;
			this.rdoCodabar.Enabled = true;
			this.rdoISBT.Enabled = true;
			this.rdoUnknown.Enabled = true;
			


			txtInvoice.Text = string.Empty;
			cmbSource.Text = string.Empty;
			this.txtScan.Text = string.Empty;
			cmbSource.SelectedIndex = 0;
			
			// **** 508 Compliance ***
			formErrorProvider.SetVbecsError( cmbSource, String.Empty );
			formErrorProvider.SetVbecsError( txtInvoice, String.Empty );
			formErrorProvider.SetVbecsError( dtpProcessingDT, String.Empty );
			
			txtInvoice.Focus();		
			
		}

		private void ReattachValidStateChangeEventHandlers()
		{
			_Shipment.Valid += new System.EventHandler( OnValidStateChanges );
			_Shipment.Invalid += new System.EventHandler( OnValidStateChanges );
			_Shipment.LocalSupplier.Valid += new System.EventHandler( OnValidStateChanges );
			_Shipment.LocalSupplier.Invalid += new System.EventHandler( OnValidStateChanges );
		}

		private void OnValidStateChanges( object sender, System.EventArgs e )
		{
			bool shipmentTypeSet = (this.rdoCodabar.Checked || this.rdoISBT.Checked);
			btnOK.EnabledButton = _Shipment.IsValid && _Shipment.LocalSupplier.IsValid && shipmentTypeSet && (this._processedByError == string.Empty);
			if(!shipmentTypeSet)
			{
				btnOK.SetToolTip( Common.Utility.SumBrokenRulesMessages( _Shipment.GetBrokenRulesMessage(this.Name), this._processedByError, _Shipment.LocalSupplier.GetBrokenRulesMessage(this.Name) ) +  "A shipment type must be selected.");
			}
			else
			{
				btnOK.SetToolTip( Common.Utility.SumBrokenRulesMessages( _Shipment.GetBrokenRulesMessage(this.Name), this._processedByError, _Shipment.LocalSupplier.GetBrokenRulesMessage(this.Name) ) );
			}			
		}

		private void OnClear(object sender, System.EventArgs e)
		{
			dtpProcessingDT.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		/// Sets/resets shipment date
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnShipmentLoad(object sender, System.EventArgs e)
		{
			this.dtpProcessingDT.Value = this._Shipment.ShipmentDate;
		}

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//set custom date and time format
			this.dtpProcessingDT.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			//set current date value based on the division time zone
			this.dtpProcessingDT.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		private string GetOKButtonToolTip()
		{
			string toolTip = string.Empty;
			//
			bool everythingIsValid = _Shipment.IsValid && _Shipment.LocalSupplier.IsValid;
			bool shipmentTypeSet = (this.rdoCodabar.Checked || this.rdoISBT.Checked);
			bool processedBySet = (this.cmbProcessedBy.Text.Trim().Length > 0);
			btnOK.EnabledButton = everythingIsValid && shipmentTypeSet && this._processedByError == string.Empty;
			string messageText =  Common.StrRes.Tooltips.UC001.ClicktoAddUnitstoShipment().ResString;
			string sumBrokenRules = Common.Utility.SumBrokenRulesMessages( _Shipment.GetBrokenRulesMessage(this.Name), _Shipment.LocalSupplier.GetBrokenRulesMessage(this.Name) );
			//CR 3149
			if(!shipmentTypeSet && !processedBySet)
			{
				toolTip = everythingIsValid ? "A Labeling Type must be selected." :	string.Concat(sumBrokenRules, "\r\nA Labeling Type must be selected.");
				toolTip = string.Concat(toolTip, " Processed By must be selected.");
			}
			if(!shipmentTypeSet && processedBySet)
			{
				toolTip = everythingIsValid ? "A Labeling Type must be selected." :	string.Concat(sumBrokenRules, "\r\nA Labeling Type must be selected.");
			}
			if(!processedBySet && shipmentTypeSet)
			{
				toolTip = everythingIsValid ? "A Processed By name must be selected." :	string.Concat(sumBrokenRules, "\r\nA Processed By must be selected.");
			}
			if(shipmentTypeSet && processedBySet)
			{
				toolTip = everythingIsValid ? messageText : sumBrokenRules;
			}
			//
			return toolTip;
		}

		#endregion

		#region Events

		/// <summary>
		/// Controls the saving of a Invoice
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if( cmbSource.Text.Length > 0 )
			{
				CheckExistingShipment();
				System.DateTime processingDate = System.Convert.ToDateTime(this.dtpProcessingDT.Text);

				System.Collections.ArrayList alExistingShipments = BOL.IncomingShipment.GetIncomingShipments(this.txtInvoice.Text, _Shipment.LocalSupplier.LocalSupplierGuid, this.dtpProcessingDT.Value);
				//If only one shipment matches the search criteria
				if(alExistingShipments.Count == 1)
				{
					//BR_1.54
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC001.AddUnitsToExistingInvoice());
						
					if (_result == DialogResult.No)
					{
                        this.ResetFormControlsAndBusinessObjects();
						return;
					}						
					this.dtpProcessingDT.Text = Common.VBECSDateTime.FormatDateTimeString(this._Shipment.ShipmentDate);
					this.dtpProcessingDT.Enabled = false;
					this.txtInvoice.Enabled = false;
					this.cmbSource.Enabled = false;
					this.cmbProcessedBy.Enabled = true;					
				}
				else if(alExistingShipments.Count > 1)
				{
					DlgSelectIncomingShipment dlg = new DlgSelectIncomingShipment(alExistingShipments);
					DialogResult result = dlg.ShowDialog(this);
					if(result == System.Windows.Forms.DialogResult.Cancel)
					{
						this.ResetFormControlsAndBusinessObjects();
						return;
					}
					else
					{
						BOL.IncomingShipment incomingShipment = new BOL.IncomingShipment(dlg.ShipmentGuid);
						this.dtpProcessingDT.Value = incomingShipment.ShipmentDate;
						this.txtInvoice.Text = incomingShipment.InvoiceNumber;
						this.cmbSource.Text = incomingShipment.LocalSupplier.FacilityName;
						incomingShipment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
						this.txtInvoice.Enabled = false;
						this.cmbSource.Enabled = false;
						this.dtpProcessingDT.Enabled = false;
						this.cmbProcessedBy.Enabled = true;
						this._Shipment = incomingShipment;
						this.dtpProcessingDT.Text = Common.VBECSDateTime.FormatDateTimeString(this._Shipment.ShipmentDate);
					}
				}
				else if(this.txtInvoice.Text.Trim().Length > 0 && this.cmbSource.Text.Trim().Length > 0)
				{
					//BR_1.55
					if( GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC001.CreateNewInvoice()) == DialogResult.No )
					{
						ResetFormControlsAndBusinessObjects();
						bool everythingIsValid = _Shipment.IsValid && _Shipment.LocalSupplier.IsValid;
						bool shipmentTypeSet = (this.rdoCodabar.Checked || this.rdoISBT.Checked);
						btnOK.EnabledButton = everythingIsValid && shipmentTypeSet && (this._processedByError == string.Empty);
						return;
					}
				}
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError(this.cmbSource,"");
			}

			FrmProcessShipmentIn frm = new FrmProcessShipmentIn(this.Codabar);
			frm.Shipment = this._Shipment;
			frm.ProcessingTechId = GetProcessingTechID();
			frm.MdiParent = this.MdiParent;
			frm.Show();
			this.IsDirty = false;
			this.Close();
		}


		private string GetProcessingTechID()
		{
			foreach(Object obj in this._alVbecsUsers)
			{
				BOL.VbecsUser vbecsUser = (BOL.VbecsUser) obj;
				if(vbecsUser.UserName.Trim() == this.cmbProcessedBy.Text.Trim())
				{
					return vbecsUser.UserNTLoginID;
				}																		 
			}
			return string.Empty;
		}
		/// <summary>
		/// Cancels the saving of the invoice and closes the form
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}


		private void rdoUnknown_CheckedChanged(object sender, System.EventArgs e)
		{
			pictureBox6.Visible = rdoUnknown.Checked;
			txtScan.Visible = rdoUnknown.Checked;
			if(rdoUnknown.Checked)
			{
				txtScan.Text = string.Empty;
			}
			txtScan.Focus();
		}

		/// <summary>
		/// Leave event for Shipment date field.  Sets shipment date in shipment object.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpProcessingDT_Leave(object sender, System.EventArgs e)
		{
			try
			{
				//BR_1.51
				this._Shipment.ShipmentDate = dtpProcessingDT.Value;
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError(this.dtpProcessingDT,"");
			}
			catch(BOL.BusinessObjectException err)
			{
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError(this.dtpProcessingDT,err.Message);
			}
			catch(Exception err)
			{
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError(this.dtpProcessingDT,err.Message);
			}
		}

		/// <summary>
		/// Fires when user leaves Collection Facility dropdown
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbSource_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			cmbSourceChange(sender,e);
			dtpProcessingDT_Leave(sender, e);
		}

		
		private void cmbSourceChange(object sender, System.EventArgs e)
		{
			if(this.cmbSource.SelectedIndex != -1)
			{
				this.IsDirty = true;
				CheckExistingShipment();
			}
		}

		private void CheckExistingShipment()
		{
			try
			{
				//bool bFound = false;
				BOL.ProductShipper productShipper = null;
				
			
				Common.DataItem dataItem = (Common.DataItem) cmbSource.Items[cmbSource.SelectedIndex];
				if(dataItem.ID.ToString().Trim() == string.Empty)
				{
					return;
				}
				productShipper = new BOL.ProductShipper(new System.Guid(dataItem.ID.ToString()));


				if(productShipper.ProductShipperGuid == System.Guid.Empty)
				{
					_Shipment.ProductShipper.ProductShipperGuid = System.Guid.Empty;
					return;
				}
				if(productShipper != null)
				{
					//BR_1.56
					_Shipment.IsNew = false;
								
					this._Shipment = new BOL.IncomingShipment(this.txtInvoice.Text, productShipper.LocalSupplierGuid, productShipper.ProductShipperGuid, this.dtpProcessingDT.Value);
					_Shipment.SetInitialBrokenRules( this.Name, "Shipment" );
					_Shipment.ProductShipper = productShipper;
					_Shipment.LocalSupplier = new BOL.LocalSupplier(productShipper.LocalSupplierGuid, true);
					_Shipment.LocalSupplier.SetInitialBrokenRules( this.Name, "LocalSupplier" );
					this._Shipment.ShipmentDirection = Common.ShipmentDirection.IncomingShipment;
				
					_Shipment.LocalSupplier.SetInitialBrokenRules( this.Name, "LocalSupplier" );
					ReattachValidStateChangeEventHandlers();
					// unbreaking the rule that's initially broken
					_Shipment.LocalSupplier.LocalSupplierGuid = productShipper.LocalSupplierGuid;				
					_Shipment.InvoiceNumber = this.txtInvoice.Text;
					if( _Shipment.ShipmentGuid != System.Guid.Empty )
					{
						this.dtpProcessingDT.Text = Common.VBECSDateTime.FormatDateTimeString(_Shipment.ShipmentDate.ToString());
					}
					else
					{
						_Shipment.ShipmentDate = this.dtpProcessingDT.Value;
					}
				}
			}
			catch (NullReferenceException)
			{
			}
			catch(BOL.BusinessObjectException err)
			{
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError( cmbSource, err.Message );
			}
			catch(Exception err)
			{
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError( cmbSource, err.Message );
			}
		}

		private void txtInvoice_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				//If they change the invoice number then check the existing shipment again.
				if(	_Shipment.InvoiceNumber.Trim() != txtInvoice.Text && txtInvoice.Text.Length != 0)
				{
					this.IsDirty = true;
					CheckExistingShipment();
				}
				_Shipment.InvoiceNumber = txtInvoice.Text;
				cmbSource.Enabled = (txtInvoice.Text.Length > 0);
				this.dtpProcessingDT.Enabled = (txtInvoice.Text.Length > 0);
				this.cmbProcessedBy.Enabled = (txtInvoice.Text.Length > 0);
				dtpProcessingDT_Leave(sender, e);
			}
			catch(BOL.BusinessObjectException err)
			{
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError( btnSelectInvoice, err.Message );
			}
			catch(Exception err)
			{
				// **** 508 Compliance ***
				this.formErrorProvider.SetVbecsError( btnSelectInvoice, err.Message );
			}
		}

		/// <summary>
		/// Fires when user hovers over OK button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			btnOK.SetToolTip( GetOKButtonToolTip() );
		}

		private void cmbSource_TextChanged(object sender, System.EventArgs e)
		{
			if(cmbSource.Text.Trim().Length == 0)
				this._Shipment.LocalSupplier.LocalSupplierGuid = Guid.Empty;

			if(cmbSource.SelectedIndex == -1)
			{
				cmbSourceChange( sender,e );
				dtpProcessingDT_Leave( sender, e );
			}
		}

		private void btnSelectInvoice_Click(object sender, System.EventArgs e)
		{
			DlgSelectIncomingShipment dlg = new DlgSelectIncomingShipment();
			
			
			DialogResult result = dlg.ShowDialog(this);
			if(result == System.Windows.Forms.DialogResult.Cancel)
			{
				//do nothing
			}
			else
			{
				BOL.IncomingShipment incomingShipment = new BOL.IncomingShipment(dlg.ShipmentGuid);
				

				this.dtpProcessingDT.Value = incomingShipment.ShipmentDate;
				this.txtInvoice.Text = incomingShipment.InvoiceNumber;
				this.cmbSource.Text = incomingShipment.LocalSupplier.FacilityName;
				
				this.txtInvoice.Enabled = false;
				this.cmbSource.Enabled = false;
				this.dtpProcessingDT.Enabled = false;
				this.cmbProcessedBy.Enabled = true;
				this._Shipment = incomingShipment;
			}
		}

		private void txtScan_TextChanged(object sender, System.EventArgs e)
		{
			if(!this.txtScan.Barcode)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.txtScan, "Please scan a barcode.");
				this.txtScan.Focus();
			}
			if(txtScan.Text.Length >= 3)
			{		
				this.IsDirty = true;
				if(txtScan.BarcodeType == Common.BarcodeType.ISBT128)
				{
					this.txtScan.Text = string.Empty;
					this.rdoISBT.Checked = true;
				}
				else if(txtScan.BarcodeType == Common.BarcodeType.Codabar)
				{
					this.rdoCodabar.Checked = true;
				}
				else
				{
					this.rdoUnknown.Checked = true;
				}
			}
			btnOK_MouseHover(sender, e);
		}

		private void rdoCodabar_CheckedChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			btnOK_MouseHover(sender, e);
		}

		private void rdoISBT_CheckedChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			btnOK_MouseHover(sender, e);
		}

		private void cmbProcessedBy_Leave(object sender, System.EventArgs e)
		{
			bool bFound = false;
			foreach(Object obj in this._alVbecsUsers)
			{
				BOL.VbecsUser vbecsUser = (BOL.VbecsUser) obj;
				if(vbecsUser.UserName.Trim() == this.cmbProcessedBy.Text.Trim())
				{
					this.IsDirty = true;
					if(this._Shipment.IsValid)
					{
						this.btnOK.EnabledButton = true;
					}
					this._processedByError = string.Empty;
					bFound = true;
					break;
				}																		 
			}
			if(!bFound)
			{
				this.btnOK.EnabledButton = false;
				this._processedByError = "A valid tech id is required.";
				//CR 3149
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmShipmentIn_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = !this.btnOK.EnabledButton ? GetOKButtonToolTip() : string.Empty;
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion
	}
}